// |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
//
// Coded by Travis Beckham
// http://www.squidfingers.com | http://www.podlob.com
// If want to use this code, feel free to do so, but please leave this message intact.
// If you do remove this, I will hunt you down :)
//
// |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
// --- myapi version date: 03/29/02 ------------------------------------------------------
//
// ---------------------------------------------------------------------------------------
// Several functions added or modified by Scott Upton, Uptonic.com
// January 2005
// ---------------------------------------------------------------------------------------

Detect = function(){
var agent = navigator.userAgent.toLowerCase();
this._mac = agent.indexOf('mac') != -1;
this._win = !this._mac;
this._w3c = document.getElementById;
this._iex = document.all;
this._ns4 = document.layers;
}
Detect.prototype.getObj = function(name){
if(this._w3c){
return document.getElementById(name);
}else if(this._iex){
return document.all[name];
}else if(this._ns4){
return this.getObjNS4(document,name);
}
}
Detect.prototype.getObjNS4 = function(obj, name){
var d = obj.layers;
var result,temp;
for(var i=0; i<d.length; i++){
if(d[i].id == name){
result = d[i];
}else if(d[i].layers.length){
var temp = this.getObjNS4(d[i],name);
}
if(temp){
result = temp;
}
}
return result;
}
Detect.prototype.getStyle = function(obj){
return (this._ns4) ? obj : obj.style;
}
Detect.prototype.getWindowWidth = function(){ // width of the window
return this._iex ? document.body.clientWidth : window.innerWidth;
}
Detect.prototype.getWindowHeight = function(){ // height of the window
return this._iex ? document.body.clientHeight : window.innerHeight;
}
Detect.prototype.getScrollTop = function(){ // top scroll position of the window
return this._iex ? document.body.scrollTop : window.pageYOffset;
}
Detect.prototype.getScrollLeft = function(){ // left scroll position of the window
return this._iex ? document.body.scrollLeft : window.pageXOffset;
}
Detect.prototype.setScrollTop = function(n){ // set the vertical scroll position of the window
window.scrollTo(this.getScrollLeft(),n);
}
Detect.prototype.setScrollLeft = function(n){ // set the horizontal scroll position of the window
window.scrollTo(n,this.getScrollTop());
}
Detect.prototype.setScroll = function(x,y){ // set the x,y scroll position of the window
window.scrollTo(x,y);
}

// :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

// HTMLobj Constructor

HTMLobj = function(name){
if(name){
this._inherit = Detect; this._inherit(name);
this._id = name;
this._el = this.getObj(this._id);
this._css = this.getStyle(this._el);
this._obj = name+'Object'; eval(this._obj+'=this');
this._timer = null;
this._glideRunning = false;
this._tweenRunning = false;
this._fadeRunning = false; // Added by SU, Couloir
this._randNum = null; // Added by SU, Couloir
this._startFade = false; // Added by SU, Couloir
return this;
}
}
HTMLobj.prototype = new Detect();

HTMLobj.prototype.getLeft = function(){ // left position of the element
return parseInt(this._css.left || 0);
}
HTMLobj.prototype.getTop = function(){ // top position of the element
return parseInt(this._css.top || 0);
}
HTMLobj.prototype.getWidth = function(){ // width of the element
if(this._ns4){
return this._el.document.width;
}else{
return this._el.offsetWidth;
}
}
HTMLobj.prototype.getHeight = function(){ // height of the element
if(this._ns4){
return this._el.document.height;
}else{
return this._el.offsetHeight;
}
}
HTMLobj.prototype.getClipWidth = function(){ // clip width of the element
if(this._ns4){
return this._el.clip.width;
}else{
return this._el.offsetWidth;
}
}
HTMLobj.prototype.getClipHeight = function(){ // clip height of the element
if(this._ns4){
return this._el.clip.height;
}else{
return this._el.offsetHeight;
}
}
HTMLobj.prototype.setStyle = function(prop, val){ // change the value of any css property
if(!this._ns4){
this._el.style[prop] = val;
if(this._iex && this._mac){
this._el.innerHTML = this._el.innerHTML;
}
}
}
HTMLobj.prototype.show = function(){ // show the visibility of the element
this._css.visibility = 'visible';
}
HTMLobj.prototype.hide = function(){ // hide the visibility of the element
this._css.visibility = 'hidden';
}
HTMLobj.prototype.showhide = function(){ // toggle the visibility of the element
if(this._css.visibility == 'hidden' || this._css.visibility == 'hide'){
this._css.visibility = 'visible';
}else{
this._css.visibility = 'hidden';
}
}
HTMLobj.prototype.setInner = function(html){ // change the contents of the element
if(this._ns4){
this._el.document.open();
this._el.document.write(html);
this._el.document.close();
}else{
this._el.innerHTML = html;
}
}
HTMLobj.prototype.moveTo = function(x,y){ // move the element to a new position
if(this._ns4){
this._el.moveTo(x,y);
}else{
this._css.left = x;
this._css.top = y;
}
}
HTMLobj.prototype.moveBy = function(x,y){ // move the element to a new position relative to it's current position
if(this._ns4) {
this._el.moveBy(x,y);
}else{
this._css.left = this.getLeft()+x;
this._css.top = this.getTop()+y;
}
}
HTMLobj.prototype.sizeTo = function(w,h){ // set the size of the element
if(!this._ns4){
this._css.width = w+'px';
this._css.height = h+'px';
}
}
HTMLobj.prototype.sizeBy = function(w,h){ // set the size of the element relative to it's current size
if(!this._ns4){
this._css.width = this.getWidth()+w+'px';
this._css.height = this.getHeight()+h+'px';
}
}
HTMLobj.prototype.glideTo = function(x,y,callback){ // ease-out animation, callback function optional
if(this._glideRunning){
var left = this.getLeft();
var top = this.getTop();
if(Math.abs(left-x)<=1 && Math.abs(top-y)<=1){
this.moveTo(x,y);
this.cancelGlide();
if(callback){
eval(this._obj+'.'+callback+'()');
}
}else{
this.moveTo(left+(x-left)/2, top+(y-top)/2);
}
}else{
var c = (callback) ? ',\"'+callback+'\"' : '' ;
this._timer = setInterval(this._obj+'.glideTo('+x+','+y+c+')',100);
this._glideRunning = true;
}
}
HTMLobj.prototype.cancelGlide = function(){ // cancel the glideTo method
clearInterval(this._timer);
this._timer = null;
this._glideRunning = false;
}
HTMLobj.prototype.swapDepth = function(obj){ // swap the z-index of 2 elements
var temp = this._css.zIndex;
this._css.zIndex = obj._css.zIndex;
obj._css.zIndex = temp;
}
// -------------------------------------------
// Modified by SU, Uptonic.com
// -------------------------------------------
HTMLobj.prototype.tweenTo = function(method, start, end, time){ // time-based animation, with multiple easing methods
// method: a function that takes 4 arguments: time, start, change, and duration
// start: array of starting width, height dimensions [w, h]
// end: array of ending width, height dimensions [w, h]
// time: number of 'frames' it takes to get to the end position
if(!this._tweenRunning){
this._tweenTime = 0;
var s = '['+start.toString()+']';
var e = '['+end.toString()+']';
this._timer = setInterval(this._obj+'.tweenTo('+method+','+s+','+e+','+time+')', 33);
this._tweenRunning = true;
}
if(++this._tweenTime > time){
this.cancelTween();
}else{
var w = method(this._tweenTime, start[0], end[0]-start[0], time);
var h = method(this._tweenTime, start[1], end[1]-start[1], time);
this.sizeTo(w,h);
}
}
HTMLobj.prototype.cancelTween = function(){ // cancel the tweenTo method
clearInterval(this._timer);
this._timer = null;
this._tweenRunning = false;
this._startFade = true;
}

// -> Easing Equations by Robert Penner - robertpenner.com -
linearTween = function(t, b, c, d){
return c*t/d + b;
}
easeInQuad = function(t, b, c, d){
t /= d;
return c*t*t + b;
}
easeOutQuad = function(t, b, c, d){
t /= d;
return -c * t*(t-2) + b;
}
easeInOutQuad = function(t, b, c, d){
t /= d/2;
if (t < 1) return c/2*t*t + b;
t--;
return -c/2 * (t*(t-2) - 1) + b;
}
easeInExpo = function(t, b, c, d){
return c * Math.pow( 2, 10 * (t/d - 1) ) + b;
}
easeOutExpo = function(t, b, c, d){
return c * ( -Math.pow( 2, -10 * t/d ) + 1 ) + b;
}
// -------------------------------------------
// Added by SU, Uptonic.com
// December 2004 - January 2005
// -------------------------------------------
HTMLobj.prototype.getRandom = function(start,end){ // generate new random number
this._randNum= Math.round(start + ((end-start) * Math.random()));
return this._randNum;
}
HTMLobj.prototype.setOpacity = function(opacity){ // set opacity of the element
// Fix for math error in some browsers
opacity = (opacity == 100)?99.999:opacity;
// IE/Windows
this._css.filter = "alpha(opacity:"+opacity+")";
// Safari < 1.2, Konqueror
this._css.KHTMLOpacity = opacity/100;
// Older Mozilla and Firefox
this._css.MozOpacity = opacity/100;
// Safari 1.2, newer Firefox and Mozilla, CSS3
this._css.opacity = opacity/100;
}
HTMLobj.prototype.fadeOut = function(opacity, change, speed){ // gradually decrease the opacity of the element
// opacity: starting opacity of element
// change: the size of the increments between steps
// speed: the rate of the animation
if (opacity >= 0){
this._fadeRunning = true;
this.setOpacity(opacity);
opacity -= change;
setTimeout(this._obj+'.fadeOut('+opacity+','+change+','+speed+')', speed);
} else {
this._fadeRunning = false;
this.hide();
}
}
HTMLobj.prototype.fadeIn = function(opacity, change, speed){ // gradually increase the opacity of the element
// opacity: starting opacity of element
// change: the size of the increments between steps
// speed: the rate of the animation
if (opacity <= 100){
this.show();
this._fadeRunning = true;
this.setOpacity(opacity);
opacity += change;
setTimeout(this._obj+'.fadeIn('+opacity+','+change+','+speed+')', speed);
} else {
this._fadeRunning = false;
this.setOpacity(100);
}
}
HTMLobj.prototype.displayShow = function(){ // display the element as 'block'
this._css.display = 'block';
}
HTMLobj.prototype.displayHide = function(){ // do not display the element
this._css.display = 'none';
}
HTMLobj.prototype.setSrc = function(target){ // set the element's source to target
this._el.src = target;
}
HTMLobj.prototype.setHref = function(target){ // set the element's link to target
this._el.href = target;
}
HTMLobj.prototype.setInnerHtml = function(content){ // set the element's inner HTML to content
this._el.innerHTML = content;
}