<?php
/*
*ทดลองสร้าง watermark plugin ของ phpthumbnailer
*/

class watermarklib {
	
	protected $parentInstance;
	protected $currentDimensions;
	protected $workingImage;
	protected $newImage;
	protected $options;
	
	/**
	* watermark($imagesource) สร้าง watermark หรือลายน้ำ
	* เอามาจาก http://www.gen-x-design.com/projects/php-thumbnailer-class/ ความเห็นของ Javier
	* การใช้งาน 
	* $thumb = image::create(”image/to/watermark.jpg”);
	* $thumb->resize(360,355);
	* $thumb->watermark(”path/to/watermark.png”);
	* $thumb->show();
	*/
	public function watermark($imagesource, &$that){
		// bring stuff from the parent class into this class...
		$this->parentInstance 		= $that;
		$this->currentDimensions 	= $this->parentInstance->getCurrentDimensions();
		$this->workingImage			= $this->parentInstance->getWorkingImage();
		$this->newImage				= $this->parentInstance->getOldImage();
		$this->options				= $this->parentInstance->getOptions();
		$pathinfo = pathinfo($imagesource);
		$var1 = $pathinfo['extension'];
		$var1 = strtolower($var1);
		$var2 = "png";
		$var3 = "jpeg";
		$var4 = "jpg";
		$var5 = "gif";
		
		if($var1 == $var2){
			$watermark = @imagecreatefrompng($imagesource);
		}elseif((strcasecmp($var1, $var3) == 0) || (strcasecmp($var1, $var4) == 0)){
			$watermark = @imagecreatefromjpeg($imagesource);
		}elseif(strcasecmp($var1, $var5) == 0){
			$watermark = @imagecreatefromgif($imagesource);
		}
		$watermarkwidth = imagesx($watermark);
		$watermarkheight = imagesy($watermark);
		$sw = $this->currentDimensions['width'];
		$sh = $this->currentDimensions['height'];
		$startwidth = ($sw/2)-($watermarkwidth/2);
		//$startwidth = ($sw - $watermarkwidth);
		$startheight = ($sh/2) - ($watermarkheight/2);
		//die($startwidth);
		//imagecopy  ( resource $dst_im  , resource $src_im  , int $dst_x  , int $dst_y  , int $src_x  , int $src_y  , int $src_w  , int $src_h  )
		imagecopy($this->workingImage, $watermark, $startwidth, $startheight, 0, 0, $watermarkwidth, $watermarkheight);
	}//watermark
	
}

$pt = PhpThumb::getInstance();
$pt->registerPlugin('watermarklib','gd');

?>